//
//  TransactionRecipientViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 22.02.23.
//

import UIKit
import JNGradientLabel


class TransactionRecipientViewController : UIViewController, UITextFieldDelegate {
    
    @IBOutlet var topBarLabel: JNGradientLabel!
    
    
    @IBOutlet var recipientLabel: UILabel!
    @IBOutlet var recipientTextField: UITextField!
    

    @IBOutlet var IBANLabel: UITextField!
    @IBOutlet var IBANTextField: UITextField!

    @IBOutlet var errorRecipientLabel: UILabel!
    @IBOutlet var errorIBANLabel: UILabel!
    
    @IBOutlet var continueButton: UIButton!
    
    fileprivate var correctRecipient = false
    fileprivate var correctIBAN = false
    
    fileprivate var _kbSize:CGSize!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // https://stackoverflow.com/questions/24687238/changing-navigation-bar-color-in-swift
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.white,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        // change button text if we returned from summary navigation controller, i.e., user wants to change a single field
        if(returnedFromTransactionSummaryView == true) {
            continueButton.setTitle("Übernehmen", for: .normal)
        }
        
        // load stored values related to recent user input data
        if transactionRecipientPublic != "" && transactionIBANPublic != ""{
            recipientTextField.text = transactionRecipientPublic
            IBANTextField.text = transactionIBANPublic
        }
        
        print(recipientTextField.text)
        print(IBANTextField.text)
        
        if transactionRecipientPublic != "" &&
            Utilities.isTransactionRecipientValid(transactionRecipientPublic) == true &&
            transactionIBANPublic.replacingOccurrences(of: " ", with: "") != userIBANPublic &&
            (Utilities.isIBANValid(transactionIBANPublic.replacingOccurrences(of: " ", with: "")) == true || Utilities.isIBANEPCValidTest(transactionIBANPublic.replacingOccurrences(of: " ", with: "")) == true)
        {
                Utilities.styleFilledButtonAuthScreenGreenEdged(continueButton)
        } else {
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
        }
        
        recipientTextField.becomeFirstResponder()
        NotificationCenter.default.addObserver(self, selector: #selector(self.keyboardWillShow(_:)), name: UIResponder.keyboardWillShowNotification, object: nil)
        
        // Close Keyboard on tab gesture
        //https://stackoverflow.com/questions/24126678/close-ios-keyboard-by-touching-anywhere-using-swift
        //let tapGesture = UITapGestureRecognizer(target: view, action: #selector(UIView.endEditing))
         //view.addGestureRecognizer(tapGesture)
        
        // style continue button
        Utilities.styleTextField(recipientTextField)
        Utilities.styleTextField(IBANTextField)
        
        continueButton.isUserInteractionEnabled = true
        continueButton.translatesAutoresizingMaskIntoConstraints = false
        
        recipientTextField.font = Fonts.mediumFontWithSize(size: 17)
        IBANTextField.font = Fonts.mediumFontWithSize(size: 14)
        
        continueButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 17)
        
        recipientLabel.font = Fonts.mediumFontWithSize(size: 17)
        IBANLabel.font = Fonts.mediumFontWithSize(size: 17)
        // hide error labels
        errorRecipientLabel.alpha = 0
        errorIBANLabel.alpha = 0
        
        errorRecipientLabel.font = Fonts.lightFontWithSize(size: 14)
        errorIBANLabel.font = Fonts.lightFontWithSize(size: 14)
        
        
        // top bar gradient color
        let gradientColors: [UIColor]    = [UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0), UIColor(red: 67/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0)]
        let gradientlocations: [CGFloat] = [1.0, 0.0]
        
        topBarLabel.textColor = .white
        topBarLabel.textGradientLocation = .background
        topBarLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
                                                                endPoint: CGPoint(x: 1.0, y: 1.0),
                                                                colors: gradientColors,
                                                                locations: gradientlocations)
        
        // required for character counter
        //self.recipientTextField.delegate = self
        // for maximum of x IBAN characters
        recipientTextField.addTarget(self, action: #selector(self.recipientTextFieldEditingDidEnd(textField:)), for: UIControl.Event.editingDidEnd)
        // required for character counter
        IBANTextField.delegate = self
        IBANTextField.addTarget(self, action: #selector(self.textFieldDidChange(textField:)), for: UIControl.Event.editingChanged)
        recipientTextField.delegate = self
        recipientTextField.addTarget(self, action: #selector(self.textFieldDidChange2(textField:)), for: UIControl.Event.editingChanged)
        
        
        
        
        IBANTextField.addTarget(self, action: #selector(self.IBANTextFieldEditingDidEnd(textField:)), for: UIControl.Event.editingDidEnd)
        // for maximum of x IBAN characters
        
        

        
        
        
        
        /*
        if correctRecipient == true && correctIBAN == true{
            continueButton.isUserInteractionEnabled = true

            Utilities.styleFilledButtonAuthScreenGreenEdged(continueButton)
            
        }
         */
    }
    
    
/*
    @IBAction func IBANTextField(_ sender: UITextField) {
    let text = sender.text?.trimmingCharacters(in: .whitespaces) ?? ""
        
        if text.count == 2 {
            sender.text?.insert(" ", at: text.index(text.startIndex, offsetBy: text.count - 1))
            //IBANTextField.text = (self.IBANTextField.text ?? "") + " "
        }
        //let text = sender.text?.trimmingCharacters(in: .whitespaces) ?? ""
          //  if !text.isEmpty && text.count == 2 && text.last != " " {
           //     sender.text = text  // trim whitespace before appending
          //      sender.text?.insert("a", at: text.index(text.startIndex, offsetBy: text.count - 1))
         //   }
    }
     */
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {

        
        print(IBANTextField.text!.replacingOccurrences(of: " ", with: ""))
        print(string)
        
        
        // workaround here
        if recipientTextField.text != "" &&
            Utilities.isTransactionRecipientValid(recipientTextField.text!) == true &&
            IBANTextField.text!.replacingOccurrences(of: " ", with: "")+string != userIBANPublic &&
            (Utilities.isIBANValid(IBANTextField.text!.replacingOccurrences(of: " ", with: "")+string) == true || Utilities.isIBANEPCValidTest(IBANTextField.text!.replacingOccurrences(of: " ", with: "")+string) == true)
        {
            
                Utilities.styleFilledButtonAuthScreenGreenEdged(continueButton)
            errorIBANLabel.alpha = 0
            } else {
                Utilities.styleFilledButtonLightGreyEdged(continueButton)
            }
        
         // workaround here, i.e. check whether user deletes a single character -> style button in gray...
        if string.count == 0 && range.length > 0 {
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
        }
        // Hinzufügen von Leerzeichen nach jeder vierten Ziffer
        if textField == IBANTextField {
            
            let text = textField.text ?? ""
            let newString = (text as NSString).replacingCharacters(in: range, with: string)
            let components = newString.components(separatedBy: .whitespacesAndNewlines).joined()
            let formatted = formatIBAN(components) // Aufruf der Funktion, um Leerzeichen einzufügen
            textField.text = formatted
            
            let startsWith : Bool = textField.text?.hasPrefix(" ") ?? false
            print(textField.text!)
            print("###" + String(startsWith))
            if startsWith {
                textField.text?.removeFirst()
            }
            
            return false // Rückgabe von false, um die Eingabe des Benutzers zu unterdrücken
        }

        return true
    }
    
    // https://stackoverflow.com/questions/30795354/resign-keyboard-when-enter-key-is-pressed-in-swift
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
            IBANTextField.becomeFirstResponder()
           return true
        }
    /*
    //https://www.hackingwithswift.com/example-code/uikit/how-to-move-to-the-next-uitextfield-when-the-user-presses-return
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        let nextTag = textField.tag + 1

        if let nextResponder = textField.superview?.viewWithTag(nextTag) {
        if let nextResponder = textField.superview?.viewWithTag(nextTag) {
            nextResponder.becomeFirstResponder()
        } else {
            textField.resignFirstResponder()
        }

        return true
    }
    */
    /*
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        recipientTextField.resignFirstResponder()
        IBANTextField.resignFirstResponder()
            return true
    }
     */


    func formatIBAN(_ iban: String) -> String {
        let formatted = iban.enumerated().map { $0.offset % 4 == 0 ? " " + String($0.element) : String($0.element) }.joined()
        return formatted
    }
    
    /*
    @IBAction func testIBAN(_ sender: UITextField) {
        sender.text
    }
    */
    
    @IBAction func continueButton(_ sender: Any) {
        
        transactionRecipientPublic = recipientTextField.text ?? ""
        let trimmedIBANString = IBANTextField.text?.trimmingCharacters(in: .whitespacesAndNewlines)
        print("IBAN: \(String(describing: trimmedIBANString))")
        transactionIBANPublic = trimmedIBANString?.uppercased() ?? ""

        if recipientTextField.text == "" {
            errorRecipientLabel.alpha = 1
            errorRecipientLabel.text = "Bitte den Empfänger oder die Empfängerin angeben."
            
        }
        /*else if Utilities.isTransactionRecipientValid(recipientTextField.text!) == false {
            errorRecipientLabel.alpha = 1
            errorRecipientLabel.text = "Der Name des Empfängers oder der Empfängerin ist zu lang."
            
        }*/
        else if IBANTextField.text!.replacingOccurrences(of: " ", with: "").uppercased() == userIBANPublic {
            errorIBANLabel.alpha = 1
            errorIBANLabel.text = "Die eingegebene IBAN ist identisch mit der IBAN dieses Girokontos."
            
        } else if Utilities.isIBANValid(IBANTextField.text!.replacingOccurrences(of: " ", with: "").uppercased()) == false {
            errorRecipientLabel.alpha = 0
            errorIBANLabel.alpha = 1
            errorIBANLabel.text = "Die IBAN ist nicht korrekt."
        } else if Utilities.isIBANEPCValidTest(IBANTextField.text!.replacingOccurrences(of: " ", with: "").uppercased()) == false {
            errorIBANLabel.alpha = 1
            errorIBANLabel.text = "Die IBAN ist nicht korrekt."
            
            // add typos in IBANs to string array list (later sent in case of successful user transaction)
            transactionTypoIBANPublic.append(IBANTextField.text!.replacingOccurrences(of: " ", with: "").uppercased())
            
            print("TransactionTypoIBANPublic:")
            dump(transactionTypoIBANPublic)
            print("###")
        } else if(returnedFromTransactionSummaryView == true) {
            let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionSummaryNC") as! UIViewController
            
            nc.modalPresentationStyle = .fullScreen
            nc.modalTransitionStyle = .coverVertical
            
            present(nc, animated: true)
        } else {
            let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionAmountNC") as! UINavigationController
            
            nc.modalPresentationStyle = .fullScreen
            nc.modalTransitionStyle = .coverVertical
            
            present(nc, animated: true)
        }
    }
    
    @IBAction func backButton(_ sender: Any) {

        let refreshAlert = UIAlertController(title: nil, message: nil, preferredStyle: UIAlertController.Style.alert)
            
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.alignment = .left

        let message = "Sind Sie sicher, dass Sie die Überweisung abbrechen wollen?\nAlle bisher eingegebenen Daten gehen verloren."
        let attributedMessage = NSAttributedString(string: message, attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle])
        
        refreshAlert.setValue(attributedMessage, forKey: "attributedMessage")

        
        refreshAlert.addAction(UIAlertAction(title: "Überweisung fortsetzen", style: .cancel, handler: { (action: UIAlertAction!) in
              print("Handle Cancel Logic here")
            
        }))
        if let continueAction = refreshAlert.actions.first(where: { $0.title == "Überweisung fortsetzen" }) {
            continueAction.setValue(UIColor(red: 49.0/255.0, green: 84.0/255.0, blue: 143.0/255.0, alpha: 1.0), forKey: "titleTextColor")
        }
        
        refreshAlert.addAction(UIAlertAction(title: "Abbrechen", style: .default, handler: { (action: UIAlertAction!) in
              print("Handle Ok logic here")
            
            // reset all transaction fields and set var to false
            backFromBackButtonOrSummaryViewController = false
            returnedFromTransactionSummaryView = false
            transactionRecipientPublic = ""
            transactionIBANPublic = ""
            transactionAmountPublic = ""
            transactionPurposePublic = ""
            
            let tabBarController = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
            
            tabBarController.modalPresentationStyle = .fullScreen
            tabBarController.modalTransitionStyle = .crossDissolve
            self.present(tabBarController, animated: true)
            
            // https://www.youtube.com/watch?v=43LpNQtUvV4
            let indexData: [String: Int] = ["index" : 1]
            NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
            
        }))
        if let cancelAction = refreshAlert.actions.first(where: { $0.title == "Abbrechen" }) {
            cancelAction.setValue(Colors.greyColor, forKey: "titleTextColor")
        }



        present(refreshAlert, animated: true, completion: nil)
    }
    
    
    @IBAction func deleteRecipientTextButton(_ sender: Any) {
        recipientTextField.text = ""
    }
    
    
    @IBAction func deleteIBANTextButton(_ sender: Any) {
        IBANTextField.text = ""
    }
    
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        //addKeyboardListeners()
    }


    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        NotificationCenter.default.removeObserver(self)
    }
    

    @objc func textFieldDidChange2(textField : UITextField){
        if recipientTextField.text == "" || Utilities.isTransactionRecipientValid(recipientTextField.text!) == false {
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
        } else if IBANTextField.text!.replacingOccurrences(of: " ", with: "") != userIBANPublic &&
                    (Utilities.isIBANValid(IBANTextField.text!.replacingOccurrences(of: " ", with: "")) == true || Utilities.isIBANEPCValidTest(IBANTextField.text!.replacingOccurrences(of: " ", with: "")) == true) {
            Utilities.styleFilledButtonAuthScreenGreenEdged(continueButton)
            errorRecipientLabel.alpha = 0
        }
        
    }
    
    
    
    @objc func textFieldDidChange(textField : UITextField){
        print("here")
        if recipientTextField.text != "" &&
            Utilities.isTransactionRecipientValid(recipientTextField.text!) == true &&
            IBANTextField.text!.replacingOccurrences(of: " ", with: "") != userIBANPublic &&
            (Utilities.isIBANValid(IBANTextField.text!.replacingOccurrences(of: " ", with: "")) == true || Utilities.isIBANEPCValidTest(IBANTextField.text!.replacingOccurrences(of: " ", with: "")) == true)
        {
                Utilities.styleFilledButtonAuthScreenGreenEdged(continueButton)
            } else {
                Utilities.styleFilledButtonLightGreyEdged(continueButton)
            }
        
        
    }
    
    
    @objc func recipientTextFieldEditingDidEnd(textField : UITextField){
        if recipientTextField.text == "" {
            errorRecipientLabel.alpha = 1
            errorRecipientLabel.text = "Bitte den Empfänger oder die Empfängerin angeben."
        } else {
            errorRecipientLabel.alpha = 0
        }
    }
     
                        
    @objc func IBANTextFieldEditingDidEnd(textField : UITextField){
        
        if IBANTextField.text!.replacingOccurrences(of: " ", with: "") == userIBANPublic {
            errorIBANLabel.alpha = 1
            errorIBANLabel.text = "Die eingegebene IBAN ist identisch mit der IBAN dieses Girokontos."
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
        } else if Utilities.isIBANValid(IBANTextField.text!.replacingOccurrences(of: " ", with: "")) == false {
            errorIBANLabel.alpha = 1
            errorIBANLabel.text = "Die IBAN ist nicht korrekt."
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
        } else if Utilities.isIBANEPCValidTest(IBANTextField.text!.replacingOccurrences(of: " ", with: "")) == false {
            errorIBANLabel.alpha = 1
            errorIBANLabel.text = "Die IBAN ist nicht korrekt."
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
            
            // add typos in IBANs to string array list (later sent in case of successful user transaction)
            transactionTypoIBANPublic.append(IBANTextField.text!.replacingOccurrences(of: " ", with: "").uppercased())
            
            print("TransactionTypoIBANPublic:")
            dump(transactionTypoIBANPublic)
            print("###")
            
        } else if recipientTextField.text == "" {
            errorRecipientLabel.alpha = 1
            errorRecipientLabel.text = "Bitte den Empfänger oder die Empfängerin angeben."
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
        }
        else {
            errorIBANLabel.alpha = 0
            Utilities.styleFilledButtonAuthScreenGreenEdged(continueButton)
        }
    }
    


    
    /*  UIKeyboardWillShowNotification. */
        @objc internal func keyboardWillShow(_ notification : Notification?) -> Void {
            
            
            
            if let info = notification?.userInfo {

                let frameEndUserInfoKey = UIResponder.keyboardFrameEndUserInfoKey
                
                //  Getting UIKeyboardSize.
                if let kbFrame = info[frameEndUserInfoKey] as? CGRect {
                    
                    let screenSize = UIScreen.main.bounds
                    
                    //Calculating actual keyboard displayed size, keyboard frame may be different when hardware keyboard is attached (Bug ID: #469) (Bug ID: #381)
                    let intersectRect = kbFrame.intersection(screenSize)
                    
                    if intersectRect.isNull {
                        _kbSize = CGSize(width: screenSize.size.width, height: 350) // default keyboard height = 350
                    } else {
                        _kbSize = intersectRect.size
                    }
                    print("Your Keyboard Size \(_kbSize)")
                    print(_kbSize.height)
                    //let rectCG = CGRect(x: 0, y: 0, width: 0, height: _kbSize.height)
                    continueButton.bottomAnchor.constraint(equalTo: view.bottomAnchor, constant: -(_kbSize.height)-10).isActive = true
                }
            }
        }
}

private var __maxLengths = [UITextField: Int]()
extension UITextField {
    @IBInspectable var maxLength: Int {
        get {
            guard let l = __maxLengths[self] else {
               return 150 // (global default-limit. or just, Int.max)
            }
            return l
        }
        set {
            __maxLengths[self] = newValue
            addTarget(self, action: #selector(fix), for: .editingChanged)
        }
    }
    @objc func fix(textField: UITextField) {
        let t = textField.text
        textField.text = t?.prefix(maxLength).string
    }
}
